/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.client;

import com.ibm.hsc.rep.client.RClientObjectId;
import com.ibm.hsc.rep.serialization.RSerializableInterface;
import com.ibm.hsc.rep.serialization.RSerializableObject;
import com.ibm.hsc.rep.serialization.RSerializableProperty;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMClient;

public class RClientObject
implements RSerializableInterface {
    private String mNameSpace;
    private String mClassName;
    private Hashtable mPropHash = new Hashtable();
    private Vector mKeyVec = new Vector();
    private static Error sNULL = new Error();

    public void loadObject(RSerializableObject rSerializableObject) {
        Vector vector = (Vector)rSerializableObject.getObject();
        int n = vector.size();
        this.mNameSpace = (String)vector.elementAt(0);
        this.mClassName = (String)vector.elementAt(1);
        int n2 = 2;
        while (n2 < n) {
            RSerializableProperty rSerializableProperty = (RSerializableProperty)vector.elementAt(n2);
            this.setProperty(rSerializableProperty.getName(), rSerializableProperty.getRValue());
            if (rSerializableProperty.isKey()) {
                this.mKeyVec.add(rSerializableProperty.getName());
            }
            ++n2;
        }
    }

    public Object writeReplace() {
        Object object;
        String string = "com.ibm.hsc.rep.RObject";
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNameSpace);
        vector.add(this.mClassName);
        Enumeration enumeration = this.mPropHash.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Object object2 = this.getProperty((String)object);
            boolean bl = false;
            if (this.mKeyVec.contains(object)) {
                bl = true;
            }
            RSerializableProperty rSerializableProperty = new RSerializableProperty(bl, (String)object, object2);
            vector.add(rSerializableProperty);
        }
        object = new RSerializableObject(string, null, vector);
        return object;
    }

    public String getNameSpace() {
        return this.mNameSpace;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public Object getProperty(String string) {
        Object v = this.mPropHash.get(string);
        if (v instanceof Error) {
            return null;
        }
        return v;
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            this.mPropHash.put(string, sNULL);
        } else {
            this.mPropHash.put(string, object);
        }
    }

    public RClientObjectId getObjectId() {
        RClientObjectId rClientObjectId = new RClientObjectId(this.mNameSpace, this.mClassName);
        int n = 0;
        while (n < this.mKeyVec.size()) {
            String string = (String)this.mKeyVec.elementAt(n);
            rClientObjectId.setKey(string, this.getProperty(string));
            ++n;
        }
        return rClientObjectId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("instance of ");
        stringBuffer.append(this.mClassName);
        stringBuffer.append(" {\n");
        Enumeration enumeration = this.mPropHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.getProperty(string);
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (objectArray != null) {
                    Vector<Object> vector = new Vector<Object>();
                    int n = 0;
                    while (n < objectArray.length) {
                        vector.add(objectArray[n]);
                        ++n;
                    }
                    stringBuffer.append(vector);
                } else {
                    stringBuffer.append("null");
                }
            } else {
                stringBuffer.append(object);
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public CIMInstance getCIMInstance(CIMClient cIMClient) throws CIMException {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.mClassName, this.mNameSpace);
        CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false);
        cIMInstance = cIMClass.newInstance();
        Vector vector = cIMInstance.getProperties();
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            String string = cIMProperty.getName();
            CIMDataType cIMDataType = cIMProperty.getType();
            Object object = null;
            object = this.getProperty(string);
            CIMValue cIMValue = null;
            if (object != null) {
                cIMValue = new CIMValue(object, cIMDataType);
            }
            cIMProperty.setValue(cIMValue);
            ++n;
        }
        return cIMInstance;
    }
}

